#!/bin/bash

# Copyright 2020 The ngspice team
# Authors: Jim Monte, Holger Vogt, Dietmar Warning
# License: New BSD

if test "$1" = "?"; then
    echo "ngspice \"paranoia\" test suite"
    echo "Format: $0 [ngspice executable]"
    echo "The ngspice executable must be independent of the current directory."
    exit 1
fi

SECONDS=0

NGSPICE="$1"
NGSPICE="${NGSPICE:-ngspice}"
VALGRIND="valgrind --leak-check=full --suppressions=$(pwd)/ignore_shared_libs.supp"

# The following three take much time. They are started in the background and may be skipped after being run once.
cd examples/xspice/table
$NGSPICE -o ../../../table-generator-q-2d.log  table-generator-q-2d.sp &
$NGSPICE -o ../../../table-generator-b4-2d.log table-generator-b4-2d.sp &
$NGSPICE -o ../../../table-generator-b4-3d.log table-generator-b4-3d.sp &
cd ../../..

cd examples/control_structs
$NGSPICE -o ../../s-param.log s-param.cir
$NGSPICE -o ../../repeat3.log repeat3.sp
$NGSPICE -o ../../foreach_bjt_ft.log foreach_bjt_ft.sp
cd ../..

cd examples/delta-sigma
$NGSPICE -o ../../mod1-ct-test.log mod1-ct-test.cir
cd ../..

cd examples/digital
$NGSPICE -o ../../adder_behav.log adder_behav.cir
$NGSPICE -o ../../adder_bip.log adder_bip.cir
$NGSPICE -o ../../adder_mos.log adder_mos.cir
$NGSPICE -o ../../adder_Xspice.log adder_Xspice.cir
cd ../..

cd examples/inductive-systems
$NGSPICE -o ../../positive-definite-1.log positive-definite-1.cir
$NGSPICE -o ../../positive-definite-2.log positive-definite-2.cir
$NGSPICE -o ../../positive-definite-3.log positive-definite-3.cir
$NGSPICE -o ../../positive-definite-4.log positive-definite-4.cir
cd ../..

cd examples/measure
$NGSPICE -o ../../func_cap.log func_cap.sp
$NGSPICE -o ../../mos-meas-dc.log mos-meas-dc.sp
$NGSPICE -o ../../inv-meas-tran.log inv-meas-tran.sp
$NGSPICE -o ../../simple-meas-tran.log simple-meas-tran.sp
$NGSPICE -o ../../rc-meas-ac.log rc-meas-ac.sp
cd ../..

cd examples/memristor
$NGSPICE -o ../../memristor.log memristor.sp
$NGSPICE -o ../../memristor_x.log memristor_x.sp
cd ../..

cd examples/Monte_Carlo
$NGSPICE -o ../../MC_2_control.log MC_2_control.sp
$NGSPICE -o ../../MC_ring.log MC_ring.sp
$NGSPICE -o ../../OpWien.log OpWien.sp
$NGSPICE -o ../../MC_ring_ts.log MC_ring_ts.sp
cd ../..

cd examples/pll
$NGSPICE -o ../../pll-xspice.log pll-xspice.cir
cd ../..

cd examples/p-to-n-examples
$NGSPICE -o ../../555-timer-2.log 555-timer-2.cir
$NGSPICE -o ../../MOS1_out.log MOS1_out.cir
$NGSPICE -o ../../op-test-adi.log op-test-adi.cir
$NGSPICE -o ../../op-test.log op-test.cir
$NGSPICE -o ../../Optimos_out.log Optimos_out.cir
$NGSPICE -o ../../OP_MCP6041.log OP_MCP6041.cir
$NGSPICE -o ../../relax_osc_st.log relax_osc_st.cir
$NGSPICE -o ../../remcirc-test.log remcirc-test.cir
$NGSPICE -o ../../switch-oscillators.log switch-oscillators.cir
$NGSPICE -o ../../switch-oscillators_inc.log switch-oscillators_inc.cir
cd ../..

cd examples/transient-noise
$NGSPICE -o ../../noi-ring51-demo.log noi-ring51-demo.cir
$NGSPICE -o ../../noi-sc-tr.log noi-sc-tr.cir
$NGSPICE -o ../../rts-1.log rts-1.cir
$NGSPICE -o ../../noise_vnoi.log noise_vnoi.cir
$NGSPICE -o ../../shot_ng.log shot_ng.cir
cd ../..

cd examples/TransImpedanceAmp
$NGSPICE -o ../../output.log output.net
cd ../..

cd examples/various
$NGSPICE -o ../../FFT_Leakage.log FFT_Leakage.cir
$NGSPICE -o ../../ro_17_4.log ro_17_4.cir
$NGSPICE -o ../../3d_loop.log 3d_loop.sp
$NGSPICE -o ../../FFT_tests.log FFT_tests.cir
$NGSPICE -o ../../agauss_test.log agauss_test.cir
$NGSPICE -o ../../bjtnoise.log bjtnoise.cir
cd ../..

cd examples/vbic
$NGSPICE -o ../../DFF_Y_ECL.log DFF_Y_ECL.sp
$NGSPICE -o ../../npn_ft.log npn_ft.sp
$NGSPICE -o ../../npn_gum.log npn_gum.sp
$NGSPICE -o ../../npn_out.log npn_out.sp
$NGSPICE -o ../../self-heat.log self-heat.sp
$NGSPICE -o ../../vbic99_dc.log vbic99_dc.sp
$NGSPICE -o ../../vbic99_tran.log vbic99_tran.sp
$NGSPICE -o ../../vbic_ac_par.log vbic_ac_par.sp
cd ../..

cd examples/vdmos
$NGSPICE -o ../../100W.log 100W.sp
$NGSPICE -o ../../100W_wingspread.log 100W_wingspread.sp
$NGSPICE -o ../../crss_coss_ciss.log crss_coss_ciss.sp
$NGSPICE -o ../../dcdc.log dcdc.sp
$NGSPICE -o ../../inv_vdmos.log inv_vdmos.sp
$NGSPICE -o ../../IXTH80N20L-IXTH48P20P-quasisat.log IXTH80N20L-IXTH48P20P-quasisat.sp
$NGSPICE -o ../../IXTP6N100D2-cap.log IXTP6N100D2-cap.sp
$NGSPICE -o ../../IXTP6N100D2-n-weak-inv.log IXTP6N100D2-n-weak-inv.sp
$NGSPICE -o ../../mtriode_nch.log mtriode_nch.sp
$NGSPICE -o ../../ro_11_vdmos.log ro_11_vdmos.sp
$NGSPICE -o ../../self-heating.log self-heating.sp
$NGSPICE -o ../../soa_chk.log soa_chk.sp
$NGSPICE -o ../../theta_nch.log theta_nch.sp
$NGSPICE -o ../../VDMOS-DIO.log VDMOS-DIO.sp
$NGSPICE -o ../../vdmos-out.log vdmos-out.sp
$NGSPICE -o ../../vdmos-out_ir_mtr.log vdmos-out_ir_mtr.sp
$NGSPICE -o ../../vdmosp-out.log vdmosp-out.sp
$NGSPICE -o ../../vdmosp-out-mtr.log vdmosp-out-mtr.sp
cd ../..

cd examples/xspice
$NGSPICE -o ../../xspice_c1.log xspice_c1.cir
$NGSPICE -o ../../xspice_c2.log xspice_c2.cir
$NGSPICE -o ../../xspice_c3.log xspice_c3.cir
$NGSPICE -o ../../bug-378-test-sequence.log bug-378-test-sequence.cir
cd ../..

# waiting for the table generator files
wait
cd examples/xspice/table
$NGSPICE -o ../../../table-model-bip-2d-1.log table-model-bip-2d-1.sp
$NGSPICE -o ../../../table-model-bip-2d-2.log table-model-bip-2d-2.sp
$NGSPICE -o ../../../table-model-mos-2d-2.log table-model-mos-2d-2.sp
$NGSPICE -o ../../../table-model-mos-2d-3.log table-model-mos-2d-3.sp
$NGSPICE -o ../../../table-model-mos-2d-4.log table-model-mos-2d-4.sp
$NGSPICE -o ../../../table-model-mos-3d-2.log table-model-mos-3d-2.sp
$NGSPICE -o ../../../table-model-mos-3d-3.log table-model-mos-3d-3.sp
$NGSPICE -o ../../../table-model-mos-3d-4.log table-model-mos-3d-4.sp
$NGSPICE -o ../../../table-model-mos-3d-5.log table-model-mos-3d-5.sp
$NGSPICE -o ../../../table-model-man-3d-1.log table-model-man-3d-1.sp
$NGSPICE -o ../../../table-model-man-2d-1.log table-model-man-2d-1.sp
$NGSPICE -o ../../../combi_script.log combi_script.cir
cd ../../..


# Check the results
# Find correct response: ngspice-<version> done
# NGSPICE_OK="$NGSPICE -v | awk '/level/ {print $2;}' done"
NGSPICE_OK="ngspice-37 done"

echo "*****************************************"
echo "log files with ngspice errors:"
#grep -L "$NGSPICE_OK" ./*.log
grep -i -l "error" ./*.log
#grep -l "Error" ./*.log
echo "*****************************************"

ELAPSED="Elapsed: $(($SECONDS / 3600))hrs $((($SECONDS / 60) % 60))min $(($SECONDS % 60))sec"
echo
echo $ELAPSED

